/* @(#)mmap.c 1.0 of 20 December 1996
 *
 *      Copyright (c) 1996 by Fabien Roy.
 *      Written by Fabien Roy and       Robert Ehrlich.
 *              Fabien_Roy@free.fdn.fr          Robert.Ehrlich@inria.fr
 *              Not derived from licensed software.
 *      Permission is granted to anyone to use this software for any
 *      purpose on any computer system, and to redistribute it freely,
 *      subject to the following restrictions:
 *      1. The author is not responsible for the consequences of use of
 *              this software, no matter how awful, even if they arise
 *              from defects in it.
 *      2. The origin of this software must not be misrepresented, either
 *              by explicit claim or by omission.
 *      3. Altered versions must be plainly marked as such, and must not
 *              be misrepresented as being the original software.
 */
#include <sys/types.h>
#include <sys/mman.h>
#include <stdlib.h>
#include <syscall.h>

caddr_t mmap(caddr_t addr, size_t len, int prot, int flags, int fd, off_t  
off)
{
        int pagelessone = getpagesize() -1;
        int size;
        caddr_t pageaddress;
                /* round to next page size */
                size = (len + pagelessone) & ~pagelessone;
                /* allocate aligned pages */
                if (!(pageaddress = (caddr_t) valloc(size)))
                        return (caddr_t) -1;
                /* map it */
                if (syscall(SYS_mmap, pageaddress, size, prot, flags, fd,  
off))
                {
                        free(pageaddress);
                        return (caddr_t) -1;
                }
                return pageaddress;
}

void munmap(caddr_t addr, size_t len)
{
        syscall(SYS_munmap,addr,len);
        free(addr);
}

